function [CoordSph,psi,rho]=FonctionOnde(n,l,m,Z,varargin)

% Olivier Pujol : septembre 2013

%% Vrifications

if (n <= 0),error('La valeur de n doit tre strictement positive !');end
if (l < 0),error('La valeur de l doit tre positive ou nulle !');end
if (l >= n),error('Mauvaise valeur de l : il faut l<n !');end
if (abs(m) > l),error('Mauvaise valeur de l ou m : il faut m <= l !');end
if (Z <= 0),error('Mauvaise valeur de Z : il faut Z>=1 !');end

%% Paramtre utile : le rayon de Bohr

aB = 0.0529177E-9;  % Rayon de Bohr (m)

%% Dfinition du graphique tridimensionnel

switch length(varargin)
    case 0
        NbPointsAng = 101;     % Nombre de points --> Rsolution angulaire : 2*pi/(NbPoints-1) = 0,005*pi
        NbPointsRad = 101;     % Nombre de points minimal pour la coordonne radiale r 
        k=20;
    case 1
        NbPointsAng = varargin{1};      % Nombre de points --> Rsolution angulaire : 2*pi/(NbPoints-1) = 0,005*pi
        NbPointsRad = 101;              % Nombre de points minimal pour la coordonne radiale r 
        k=20;
    case 2
        NbPointsAng=varargin{1};
        NbPointsRad=varargin{2};
        k=20;
    case 3
        NbPointsAng=varargin{1};
        NbPointsRad=varargin{2};
        k=varargin{3};
end
if (length(varargin)>3),error('Mauvais nombre d''arguments optionnels !');end

PHI=linspace(0,2*pi,NbPointsAng); %%% 3D

THETA = linspace(0,pi,NbPointsAng);      % Colatitude (theta) des coordonnes sphriques
R = linspace(0,k*n/Z,n*NbPointsRad);        % Variable sans unit r/aB

CoordSph{1}=R;
CoordSph{2}=THETA;
CoordSph{3}=PHI;

%Remarques :    1) L'extension de la fonction radiale augmente avec n --> xmax=10*n
%               2) Il n'est pas judicieux de travailler avec X=r/rc o 
%               rc=naB/Z car alors on ne voit pas graphiquement l'effet de Z.

% % [x,theta]=meshgrid(X,THETA);    %%% 2D

% % % [x]=meshgrid(X,THETA); %%% 3D
[r,theta,phi]=meshgrid(R,THETA,PHI); %%% 3D

%% Module de la partie radiale Rnl de la fonction d'onde

%Rnl=Calc_PartieRadiale(n,l,Z,x,aB); %%% 2D
Rnl=Calc_PartieRadiale(n,l,Z,r(:,:,1),aB);  %%% 3D

%% Module de l'harmonique sphrique Ylm de la fonction d'onde 

% % % Ylm=Calc_HarmoniqueSpherique(l,m,theta); %%% 2D
Ylm=Calc_HarmoniqueSpherique(l,m,squeeze(theta(:,1,:)),squeeze(phi(:,1,:))); %%% 3D

%% Fonction d'onde et densit de probabilit volumique

% % psi=nan(size(theta,1),size(theta,2)); %%% 2D

%%% 3D
psi=nan(size(theta,1),size(r,2),size(phi,3));
for irnl=1:size(Rnl,2)
    psi(:,irnl,:)=Rnl(1,irnl).*Ylm;
end

% % %%2D
% % for ir=1:size(Rnl,2)
% %     psi(:,ir)=Rnl(:,ir).*Ylm;
% % end
rho=psi.*conj(psi);
rho(rho<eps)=0; % Mise  0 des valeurs trop petites (< 1E-16)

clear Rnl Ylm %% 3D 

%%%%%%%%%%%FONCTIONS UTILISEES%%%%%%%%%%%%%

function Rnl=Calc_PartieRadiale(n,l,Z,X,aB)
%
%   Cette fonction calcule la partie radiale R(n,l) d'un atome hydrognode, 
%   d'expression gnrale :
%
%   R(n,l)=
% 
%   Entres :   n       = nombre quantique principal
%               l       = moment cintique orbital (l<=n)
%               Z       = Nombre atomique
%               X       = Coordonne radiale
%               aB      = Rayon de Bohr    
%   Sorties :   Rnl     = Partie Radiale
%
%   Attention : on garantit le calcul jusqu' n=30
%
% Olivier Pujol : septembre 2013

%% Calcul du polynme associ de Laguerre L(n+l,2l+1)

PaLag=PolyAssoLaguerre(n,l,2*Z*X/n);    % Polynme associ de Laguerre

%% Calcul de la partie radiale R(n,l)

Facteur =(2*Z/(n*aB))^(1.5)*(gamma(n-l)/(2*n*(gamma(n+l+1))^3))^0.5;

Rnl=-Facteur*(2*Z*X/n).^l.*exp(-Z*X/n).*PaLag;  % Partie radiale

return;

% % function Ylm=Calc_HarmoniqueSpherique(l,m,theta) %%2D
function Ylm=Calc_HarmoniqueSpherique(l,m,theta,phi) %%3D
%
%   Cette fonction calcule l'harmonique sphrique Y(l,m) d'expression 
%   gnrale :
%   Y(l,m)=((2l+1)(l-|m|)!/((l+|m|)!4pi))^0.5 P(l,m)exp(i*m*phi)
%   pour phi=0 (la fonction d'onde a une symtrie de rvolution autour de
%   l'axe Oz).
% 
%   Entres :   l       = Moment cintique orbital (Nombre quantique)
%               m       = Nombre quantique magntique (|m|<l)
%               theta   = Colatitude (angle des coordonnes sphriques)
%   Sorties :   Ylm     = Harmonique sphrique
%
% Olivier Pujol : septembre 2013

%% Calcul du polynme de Legendre correspondant

% La fonction "legendre(l,X)", interne  Matlab, calcule P(l,m) pour chaque 
% lment (k) de X, compris imprativement entre -1 et 1.
% La matrice obtenue est de dimension (l+1)*length(X) ;  
% chacun de ses lments P(m+1,k) correspond  P(l,m) valu en X(k). 
% Soulignons que pour la premire ligne de P, m=0.

% % P=legendre(l,cos(theta(:,1)));          % Polynme de Legendre
P=legendre(l,cos(theta));%%3D
%% Calcul de l'harmonique sphrique considre

Facteur =((2*l+1)*factorial(l-abs(m))/(4*pi*factorial(l+abs(m))))^0.5; % Rel positif

Ylm=nan(size(theta,1),size(phi,2));%%%3D

if (l == 0)
    Ylm = Facteur.*P;  % Dans ce cas, P = 1 quel que soit phi (Y(0,0))
else
    Plm=P(abs(m)+1,:);  % P(m+1,k) = P(l,m). Ici, Plm = matrice (NbPoints * NbPoints)
    iplm=1;             % Initialisation de l'indice de Plm 
    for iphi=1:size(phi,2)    
    for itheta=1:size(theta,1)
% %         Ylm(itheta) = Facteur*Plm(iplm).*exp(j*abs(m));   % Y(l,m)  %% 2D
Ylm(itheta,iphi) = Facteur*Plm(iplm).*exp(j*abs(m).*phi(itheta,iphi));   % Y(l,m)
        iplm=iplm+1;
    end
    end
end
if (m<0),Ylm=(-1)^m*conj(Ylm);end

return;
